package com.company.tp07_03_remotetodoapp.repository;

import android.app.Application;

import androidx.lifecycle.MutableLiveData;

import com.company.tp07_03_remotetodoapp.remote.Todo;
import com.company.tp07_03_remotetodoapp.remote.retrofit.RetrofitApiInterface;
import com.company.tp07_03_remotetodoapp.remote.retrofit.RetrofitClientInstance;

import java.util.List;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class TodoRepo {

    private MutableLiveData<List<Todo>> todoList;
    private static TodoRepo instance;

    public static TodoRepo getInstance(Application application){
        if(instance==null){
            instance = new TodoRepo();
        }
        return instance;
    }

    private TodoRepo() {
        todoList = new MutableLiveData<List<Todo>>();
        RetrofitApiInterface service = RetrofitClientInstance.getRetrofitApiInterface();
        Call<List<Todo>> call = service.getTodoList();
        call.enqueue(new Callback<List<Todo>>() {
            @Override
            public void onResponse(Call<List<Todo>> call, Response<List<Todo>> response) {
                List<Todo> todos = response.body();
                todoList.setValue(todos);
            }

            @Override
            public void onFailure(Call<List<Todo>> call, Throwable t) {

            }
        });

    }
    public MutableLiveData<List<Todo>> getTodoList() {
        return todoList;
    }

}
